<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" @class(['dark' => ($appearance ?? 'system') == 'dark'])>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Inline script to detect system dark mode preference and apply it immediately --}}
    <script>
        (function() {
            const appearance = '{{ $appearance ?? 'system' }}';

            if (appearance === 'system') {
                const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                if (prefersDark) {
                    document.documentElement.classList.add('dark');
                }
            }
        })();
    </script>

    {{-- Inline style to set the HTML background color based on our theme in app.css --}}
    <style>
        html {
            background-color: oklch(1 0 0);
        }

        html.dark {
            background-color: oklch(0.145 0 0);
        }
    </style>

    <title inertia>{{ config('app.name', 'Laravel') }}</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
    <script src="{{ asset('js/jquery.min.js') }}"></script>
    @routes
    @if (app()->environment('local'))
        @viteReactRefresh
    @endif
    @vite(['resources/js/app.tsx', "resources/js/pages/{$page['component']}.tsx"])
    <script>
        // Ensure base URL is correctly set for assets
        window.baseUrl = '{{ url('/') }}';

        // Define asset helper function
        window.asset = function(path) {
            return "{{ asset('') }}" + path;
        };
        
        // Define storage helper function
        window.storage = function(path) {
            return "{{ asset('storage') }}/" + path;
        };

        // Set initial locale for i18next
        fetch('{{ route('initial-locale') }}')
            .then(response => response.text())
            .then(locale => {
                window.initialLocale = locale;
            })
            .catch(() => {
                window.initialLocale = 'en';
            });
    </script>
    @inertiaHead
</head>

<body class="font-sans antialiased !mb-0">
    @inertia
</body>

</html>
