"use strict";
exports.fr = void 0;
var _index = require("./fr/_lib/formatDistance.cjs");
var _index2 = require("./fr/_lib/formatLong.cjs");
var _index3 = require("./fr/_lib/formatRelative.cjs");
var _index4 = require("./fr/_lib/localize.cjs");
var _index5 = require("./fr/_lib/match.cjs");

/**
 * @category Locales
 * @summary French locale.
 * @language French
 * @iso-639-2 fra
 * @author Jean Dupouy [@izeau](https://github.com/izeau)
 * @author François B [@fbonzon](https://github.com/fbonzon)
 */
const fr = (exports.fr = {
  code: "fr",
  formatDistance: _index.formatDistance,
  formatLong: _index2.formatLong,
  formatRelative: _index3.formatRelative,
  localize: _index4.localize,
  match: _index5.match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 4,
  },
});
