<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (isSaas()) {
            Schema::create('payout_requests', function (Blueprint $table) {
                $table->id();
                $table->foreignId('company_id')->constrained('users')->onDelete('cascade');
                $table->decimal('amount', 10, 2);
                $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
                $table->text('notes')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        if (isSaas()) {
            Schema::dropIfExists('payout_requests');
        }
    }
};
