<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (isSaas()) {
            Schema::create('referral_settings', function (Blueprint $table) {
                $table->id();
                $table->boolean('is_enabled')->default(true);
                $table->decimal('commission_percentage', 5, 2)->default(10.00);
                $table->decimal('threshold_amount', 10, 2)->default(50.00);
                $table->text('guidelines')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        if (isSaas()) {
            Schema::dropIfExists('referral_settings');
        }
    }
};