<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (isSaas()) {
            Schema::create('plan_orders', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->foreignId('plan_id')->constrained()->onDelete('cascade');
                $table->foreignId('coupon_id')->nullable()->constrained()->onDelete('set null');
                $table->string('billing_cycle')->nullable();
                $table->string('order_number')->unique();
                $table->decimal('original_price', 10, 2);
                $table->decimal('discount_amount', 10, 2)->default(0);
                $table->decimal('final_price', 10, 2);
                $table->string('coupon_code')->nullable();
                $table->string('payment_method')->nullable();
                $table->text('payment_id')->nullable();
                $table->enum('status', ['pending', 'approved', 'rejected', 'cancelled'])->default('pending');
                $table->timestamp('ordered_at');
                $table->timestamp('processed_at')->nullable();
                $table->foreignId('processed_by')->nullable()->constrained('users')->onDelete('set null');
                $table->text('notes')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (isSaas()) {
            Schema::dropIfExists('plan_orders');
        }
    }
};
